/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.api;

import com.hrznstudio.emojiful.Emojiful;
import com.hrznstudio.emojiful.api.Emoji;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FileUtils;

public class EmojiFromTwitmoji
extends Emoji {
    public SimpleTexture img;
    public ResourceLocation resourceLocation = loading_texture;

    @Override
    public void checkLoad() {
        if (this.img != null) {
            return;
        }
        this.img = new DownloadImageData(new File("emojiful/cache/" + this.name + "-" + this.version), "https://raw.githubusercontent.com/iamcal/emoji-data/master/img-twitter-64/" + this.location, loading_texture);
        this.resourceLocation = new ResourceLocation("emojiful", "texures/emoji/" + this.location.toLowerCase() + "_" + this.version);
        Minecraft.m_91087_().m_91097_().m_118495_(this.resourceLocation, (AbstractTexture)this.img);
    }

    @Override
    public ResourceLocation getResourceLocationForBinding() {
        this.checkLoad();
        if (this.deleteOldTexture) {
            this.img.m_117964_();
            this.deleteOldTexture = false;
        }
        return this.resourceLocation;
    }

    @Override
    public boolean test(String s) {
        for (String text : this.strings) {
            if (!s.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public class DownloadImageData
    extends SimpleTexture {
        private final File cacheFile;
        private final String imageUrl;
        private NativeImage nativeImage;
        private Thread imageThread;
        private boolean textureUploaded;

        public DownloadImageData(File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation) {
            super(textureResourceLocation);
            this.cacheFile = cacheFileIn;
            this.imageUrl = imageUrlIn;
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.nativeImage != null) {
                if (this.f_118129_ != null) {
                    this.m_117964_();
                }
                TextureUtil.m_85283_((int)super.m_117963_(), (int)this.nativeImage.m_84982_(), (int)this.nativeImage.m_85084_());
                this.nativeImage.m_85040_(0, 0, 0, true);
                this.textureUploaded = true;
            }
        }

        private void setImage(NativeImage nativeImageIn) {
            Minecraft.m_91087_().execute(() -> {
                this.textureUploaded = true;
                if (!RenderSystem.m_69586_()) {
                    RenderSystem.m_69879_(() -> this.upload(nativeImageIn));
                } else {
                    this.upload(nativeImageIn);
                }
            });
        }

        private void upload(NativeImage imageIn) {
            TextureUtil.m_85283_((int)this.m_117963_(), (int)imageIn.m_84982_(), (int)imageIn.m_85084_());
            imageIn.m_85040_(0, 0, 0, true);
        }

        @Nullable
        private NativeImage loadTexture(InputStream inputStreamIn) {
            NativeImage nativeimage = null;
            try {
                nativeimage = NativeImage.m_85058_((InputStream)inputStreamIn);
            }
            catch (IOException ioexception) {
                Emojiful.LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
            }
            return nativeimage;
        }

        public void m_6704_(ResourceManager resourceManager) throws IOException {
            if (this.imageThread == null) {
                if (this.cacheFile != null && this.cacheFile.isFile()) {
                    try {
                        FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                        this.setImage(this.loadTexture(fileinputstream));
                    }
                    catch (IOException ioexception) {
                        this.loadTextureFromServer();
                    }
                } else {
                    this.loadTextureFromServer();
                }
            }
        }

        protected void loadTextureFromServer() {
            this.imageThread = new Thread("Emojiful Texture Downloader #" + Emoji.threadDownloadCounter.incrementAndGet()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection httpurlconnection = null;
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(DownloadImageData.this.imageUrl).openConnection(Minecraft.m_91087_().m_91096_());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputStream;
                            int contentLength = httpurlconnection.getContentLength();
                            if (DownloadImageData.this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)DownloadImageData.this.cacheFile);
                                inputStream = new FileInputStream(DownloadImageData.this.cacheFile);
                            } else {
                                inputStream = httpurlconnection.getInputStream();
                            }
                            DownloadImageData.this.setImage(DownloadImageData.this.loadTexture(inputStream));
                        } else {
                            EmojiFromTwitmoji.this.resourceLocation = Emoji.noSignal_texture;
                            EmojiFromTwitmoji.this.deleteOldTexture = true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        EmojiFromTwitmoji.this.resourceLocation = Emoji.error_texture;
                        EmojiFromTwitmoji.this.deleteOldTexture = true;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }
            };
            this.imageThread.setDaemon(true);
            this.imageThread.start();
        }
    }
}

